<!DOCTYPE html>
<html lang="en" <?php if($rtl == 1): ?> dir="rtl" <?php endif; ?>>
<head>
    <!--====== Required meta tags ======-->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo $__env->yieldContent('meta-description'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta-keywords'); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <?php echo $__env->yieldContent('og-meta'); ?>
    <!--====== Title ======-->
    <title><?php echo e($bs->website_title); ?> <?php echo $__env->yieldContent('pagename'); ?></title>
    <!--====== Favicon Icon ======-->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/front/img/' . $bs->favicon)); ?>" type="image/png">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/plugin.min.css')); ?>">
    
    <!-- base color change -->
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/bootstrap.min.css')); ?>">
    <!-- Fontawesome Icon CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/fonts/fontawesome/css/all.min.css')); ?>">
        <!-- Swiper Slider -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/swiper-bundle.min.css')); ?>">
    <!-- Kreativ Icon -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/fonts/icomoon/style.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/toastr.min.css')); ?>">
    <!-- Magnific Popup CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/magnific-popup.min.css')); ?>">
    <!-- AOS Animation CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/aos.min.css')); ?>">
    <!-- Nice Select -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/nice-select.css')); ?>">
    <!-- Main Style CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/style.css')); ?>">
    <!-- summernote Style CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/summernote-content.css')); ?>">
    <!-- Responsive CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/responsive.css')); ?>">
    <?php if($rtl == 1): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/rtl.css')); ?>">
    <?php endif; ?>
    <!-- base color change -->
    

    <?php echo $__env->yieldContent('styles'); ?>

    <?php if($bs->is_whatsapp == 0 && $bs->is_tawkto == 0): ?>
        <style>
            .back-to-top {
                left: auto;
                right: 30px;
            }
        </style>
    <?php endif; ?>
    <style>
        <?php echo $be->custom_css; ?>

    </style>
    <?php
        $primaryRgbColor = hex2rgb($bs->base_color);
    ?>
    <style>
        :root {
            --color-primary: #<?php echo e($bs->base_color); ?>;
            --color-primary-shade: #<?php echo e($bs->base_color2); ?>;
            --bg-light: #<?php echo e($bs->base_color2); ?>14;
            --color-primary-rgb: <?php echo e($primaryRgbColor['red'] . ',' . $primaryRgbColor['green'] . ',' . $primaryRgbColor['blue']); ?>;

        }
    </style>


    <?php if(!is_null($bs->adsense_publisher_id)): ?>
    <!------google adsense----------->
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=<?php echo e($bs->adsense_publisher_id); ?>" crossorigin="anonymous"></script>
    <!------google adsense----------->
    <?php endif; ?>
</head>

<body>

    <?php if($bs->preloader_status == 1): ?>
        <!--====== Start Preloader ======-->

        <div id="preLoader">
            <div class="loader">
                <img src="<?php echo e(asset('assets/front/img/' . $bs->preloader)); ?>" alt="Loader">
            </div>
        </div>

        <!--====== End Preloader ======-->
    <?php endif; ?>

    <?php if(!request()->routeIs('user.login')): ?>
        <?php if ($__env->exists('front.partials.header')) echo $__env->make('front.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <?php if(!request()->routeIs('front.index') && !request()->routeIs('user.login')): ?>
        <div class="page-title-area bg-primary-light">
            <div class="container">
                <div class="content text-center">
                    <h2><?php echo $__env->yieldContent('breadcrumb-title'); ?></h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('front.index')); ?>"><?php echo e(__('Home')); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('breadcrumb-link'); ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
            <!-- Bg Overlay -->
            <img class="lazyload bg-overlay-1" data-src="<?php echo e(asset('assets/frontend/images/shadow-1.png')); ?>"
                alt="Bg">
            <img class="lazyload bg-overlay-2" data-src="<?php echo e(asset('assets/frontend/images/shadow-2.png')); ?>"
                alt="Bg">

            <!-- Bg Shape -->
            <div class="shape">
                <img class="shape-1" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-2" src="<?php echo e(asset('assets/frontend/images/shape/shape-5.png')); ?>" alt="Shape">
                <img class="shape-3" src="<?php echo e(asset('assets/frontend/images/shape/shape-6.png')); ?>" alt="Shape">
                <img class="shape-4" src="<?php echo e(asset('assets/frontend/images/shape/shape-7.png')); ?>" alt="Shape">
                <img class="shape-5" src="<?php echo e(asset('assets/frontend/images/shape/shape-8.png')); ?>" alt="Shape">
                <img class="shape-6" src="<?php echo e(asset('assets/frontend/images/shape/shape-9.png')); ?>" alt="Shape">
            </div>
        </div>
        <!--====== End Breadcrumbs-section ======-->
    <?php endif; ?>

    <?php echo $__env->yieldContent('content'); ?>

    
    <?php if(!request()->routeIs('user.login')): ?>
        <?php if ($__env->exists('front.partials.footer')) echo $__env->make('front.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <!-- Go to Top -->
    <div class="go-top"><i class="fal fa-angle-double-up"></i></div>
    <!-- Go to Top -->

    <!-- Magic Cursor -->
    <div class="cursor"></div>
    <!-- Magic Cursor -->

    <?php if($be->cookie_alert_status == 1): ?>
        <div class="cookie">
            <?php echo $__env->make('cookie-consent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    <?php endif; ?>

    
    <?php if ($__env->exists('front.partials.popups')) echo $__env->make('front.partials.popups', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    
    <div id="WAButton"></div>

    

    <!-- Jquery JS -->
    <script src="<?php echo e(asset('assets/frontend/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/plugin.min.js')); ?>"></script>
    <!-- Bootstrap JS -->
    <script src="<?php echo e(asset('assets/frontend/js/bootstrap.min.js')); ?>"></script>
    <!-- Nice Select JS -->
    <script src="<?php echo e(asset('assets/frontend/js/jquery.nice-select.min.js')); ?>"></script>
    <!-- Magnific Popup JS -->
    <script src="<?php echo e(asset('assets/frontend/js/jquery.magnific-popup.min.js')); ?>"></script>
    <!-- Swiper Slider JS -->
    <script src="<?php echo e(asset('assets/frontend/js/swiper-bundle.min.js')); ?>"></script>
 
    <!-- Lazysizes -->
    <script src="<?php echo e(asset('assets/frontend/js/lazysizes.min.js')); ?>"></script>
    <!-- SVG loader -->
    <script src="<?php echo e(asset('assets/frontend/js/svg-loader.min.js')); ?>"></script>
    <!-- AOS JS -->
    <script src="<?php echo e(asset('assets/frontend/js/aos.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/frontend/js/toastr.min.js')); ?>"></script>


    <script>
        "use strict";
        var rtl = <?php echo e($rtl); ?>;
    </script>
    <!--====== Main js ======-->
    

    <!-- Main script JS -->
    <script src="<?php echo e(asset('assets/frontend/js/script.js')); ?>"></script>

    <?php echo $__env->yieldContent('scripts'); ?>

    <?php echo $__env->yieldContent('vuescripts'); ?>
    <script>
        <?php echo $be->custom_js; ?>

    </script>

    <?php if(session()->has('success')): ?>
        <script>
            "use strict";
            toastr['success']("<?php echo e(__(session('success'))); ?>");
        </script>
    <?php endif; ?>

    <?php if(session()->has('error')): ?>
        <script>
            "use strict";
            toastr['error']("<?php echo e(__(session('error'))); ?>");
        </script>
    <?php endif; ?>

    <?php if(session()->has('warning')): ?>
        <script>
            "use strict";
            toastr['warning']("<?php echo e(__(session('warning'))); ?>");
        </script>
    <?php endif; ?>
    <script>
        "use strict";

        function handleSelect(elm) {
            window.location.href = "<?php echo e(route('changeLanguage', '')); ?>" + "/" + elm.value;
        }
    </script>

    
    <?php if($bs->is_whatsapp == 1): ?>
        <script type="text/javascript">
            "use strict";
            var whatsapp_popup = <?php echo e($bs->whatsapp_popup); ?>;
            var whatsappImg = "<?php echo e(asset('assets/front/img/whatsapp.svg')); ?>";
            $(function() {
                $('#WAButton').floatingWhatsApp({
                    phone: "<?php echo e($bs->whatsapp_number); ?>", //WhatsApp Business phone number
                    headerTitle: "<?php echo e($bs->whatsapp_header_title); ?>", //Popup Title
                    popupMessage: `<?php echo !empty($bs->whatsapp_popup_message) ? nl2br($bs->whatsapp_popup_message) : ''; ?>`, //Popup Message
                    showPopup: whatsapp_popup == 1 ? true : false, //Enables popup display
                    buttonImage: '<img src="' + whatsappImg + '" />', //Button Image
                    position: "right" //Position: left | right

                });
            });
        </script>
    <?php endif; ?>

    <?php if($bs->is_tawkto == 1): ?>
        <?php
            $directLink = str_replace('tawk.to', 'embed.tawk.to', $bs->tawkto_property_id);
            $directLink = str_replace('chat/', '', $directLink);
        ?>
        <!--Start of Tawk.to Script-->
        <script type="text/javascript">
            "use strict";
            var Tawk_API = Tawk_API || {},
                Tawk_LoadStart = new Date();
            (function() {
                var s1 = document.createElement("script"),
                    s0 = document.getElementsByTagName("script")[0];
                s1.async = true;
                s1.src = '<?php echo e($directLink); ?>';
                s1.charset = 'UTF-8';
                s1.setAttribute('crossorigin', '*');
                s0.parentNode.insertBefore(s1, s0);
            })();
        </script>
        <!--End of Tawk.to Script-->
    <?php endif; ?>

</body>

</html>
<?php /**PATH /Users/samiulalimpratik/Sites/businesso/businesso/resources/views/front/layout.blade.php ENDPATH**/ ?>