<?php

namespace App\Http\Controllers\Front\DonationManagement;

use App\Constants\Constant;
use App\Http\Controllers\Controller;
use App\Http\Controllers\User\DonationManagement\Payment\AuthorizenetController;
use App\Http\Controllers\User\DonationManagement\Payment\FlutterwaveController;
use App\Http\Controllers\User\DonationManagement\Payment\InstamojoController;
use App\Http\Controllers\User\DonationManagement\Payment\MercadoPagoController;
use App\Http\Controllers\User\DonationManagement\Payment\MollieController;
use App\Http\Controllers\User\DonationManagement\Payment\OfflineController;
use App\Http\Controllers\User\DonationManagement\Payment\PayPalController;
use App\Http\Controllers\User\DonationManagement\Payment\PaystackController;
use App\Http\Controllers\User\DonationManagement\Payment\PaytmController;
use App\Http\Controllers\User\DonationManagement\Payment\RazorpayController;
use App\Http\Controllers\User\DonationManagement\Payment\StripeController;
use App\Models\User\BasicSetting;
use App\Models\User\DonationManagement\Donation;
use App\Models\User\DonationManagement\DonationContent;
use App\Models\User\DonationManagement\DonationDetail;
use App\Models\User\UserEmailTemplate;
use App\Traits\MiscellaneousTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use PDF;
use PHPMailer\PHPMailer\PHPMailer;

class DonationController extends Controller
{
    use MiscellaneousTrait;
    public function makePayment(Request $request)
    {

        $user = getUser();
        $currencyInfo = MiscellaneousTrait::getCurrencyInfo($user->id);
        $setting = DB::table('user_donation_settings')->where('user_id', $user->id)->first();
        $causeId = $request->cause_id;
        if ($setting->donation_guest_checkout == 0 && !Auth::guard('customer')->check()) {
            return redirect()->route('customer.login', [getParam(), 'redirected' => 'causes']);
        }

        if ($request->amount < $request->minimum_amount) {
            return redirect()->back()->with('error', 'Amount must be minimum ' . $request->minimum_amount . ' ' . $currencyInfo->base_currency_text)->withInput();
        }
        // dd($request->all());
        if (!$request->exists('gateway')) {
            return redirect()->back()->with('error', 'Choose a payment method')->withInput();
        } elseif ($request['gateway'] == 'paypal') {
            $paypal = new PayPalController();
            return $paypal->donationProcess($request, $causeId, $user->id);
        } elseif ($request['gateway'] == 'instamojo') {

            $paypal = new InstamojoController();
            return $paypal->donationProcess($request, $causeId, $user->id);
        } else if ($request['gateway'] == 'paystack') {
            $validator = Validator::make($request->all(), [
                'name' => $request->has('checkbox') === true ? 'max:255' : 'required',
                'email' => $request->has('checkbox') === true ? 'max:255' : 'required|email',
                'paystack_email' => $request->has('checkbox') === true ? 'required|email' : 'nullable',
                'amount' => 'required',
            ]);

            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }
            $paystack = new PaystackController();
            return $paystack->donationProcess($request, $causeId, $user->id);
        } else if ($request['gateway'] == 'flutterwave') {

            $validator = Validator::make($request->all(), [
                'name' => $request->has('checkbox') === true ? 'max:255' : 'required',
                'email' => $request->has('checkbox') === true ? 'max:255' : 'required|email',
                'flutterwave_email' => $request->has('checkbox') === true ? 'required|email' : 'nullable',
                'amount' => 'required',
            ]);
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }
            $flutterwave = new FlutterwaveController;
            return $flutterwave->donationProcess($request, $causeId, $user->id);
        } else if ($request['gateway'] == 'razorpay') {
            // dd($request->all());
            $validator = Validator::make($request->all(), [
                'name' => $request->has('checkbox') === true ? 'max:255' : 'required',
                'email' => $request->has('checkbox') === true ? 'max:255' : 'required|email',
                'razorpay_email' => $request->has('checkbox') === true ? 'required|email' : 'nullable',
                'razorpay_phone' => $request->has('checkbox') === true ? 'required|numeric' : 'nullable',
                'amount' => 'required',
            ]);
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }
            $razorpay = new RazorpayController();
            return $razorpay->donationProcess($request, $causeId, $user->id);
        } else if ($request['gateway'] == 'mercadopago') {
            $mercadopago = new MercadoPagoController();
            return $mercadopago->donationProcess($request, $causeId, $user->id);
        } else if ($request['gateway'] == 'mollie') {
            $mollie = new MollieController();
            return $mollie->donationProcess($request, $causeId, $user->id);
        } else if ($request['gateway'] == 'paytm') {
            $validator = Validator::make($request->all(), [
                'name' => $request->has('checkbox') === true ? 'max:255' : 'required',
                'email' => $request->has('checkbox') === true ? 'max:255' : 'required|email',
                'paytm_email' => $request->has('checkbox') === true ? 'required|email' : 'nullable',
                'paytm_phone' => $request->has('checkbox') === true ? 'required|numeric' : 'nullable',
                'amount' => 'required',
            ]);
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }

            $paytm = new PaytmController();
            return $paytm->donationProcess($request, $causeId, $user->id);
        } else if ($request['gateway'] == 'stripe') {
            $stripe = new StripeController();
            return $stripe->donationProcess($request, $causeId, $user->id);
        } else if ($request['gateway'] == 'authorize.net') {
            $authorizeNet = new AuthorizenetController();
            return $authorizeNet->donationProcess($request, $causeId, $user->id);
        } else {
            $validator = Validator::make($request->all(), [
                'name' => $request->has('checkbox') === true ? 'max:255' : 'required',
                'email' => $request->has('checkbox') === true ? 'max:255' : 'required|email',
                'amount' => 'required',
            ]);
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }
            $offline = new OfflineController();
            return $offline->donationProcess($request, $causeId, $user->id);
        }
    }

    public function store($information, $userId)
    {

        $curencyInfo = MiscellaneousTrait::getCurrencyInfo($userId);
        return $donation = DonationDetail::create([
            'user_id' => $userId,
            'customer_id' => Auth::guard('customer')->check() ? Auth::guard('customer')->user()->id : NULL,
            'name' => $information['name'],
            'email' => $information['email'],
            'phone' => $information['phone'],
            'amount' => $information['amount'],
            'currency' => $curencyInfo->base_currency_text,
            'currency_position' => $curencyInfo->base_currency_text_position,
            'currency_symbol' => $curencyInfo->base_currency_symbol,
            'currency_symbol_position' => $curencyInfo->base_currency_symbol_position,
            'payment_method' => $information['paymentMethod'],
            'transaction_id' => uniqid(),
            'status' => $information['paymentStatus'],
            'receipt' => $information['attachmentFile'] ?? null,
            'transaction_details' => $information['gatewayType'],
            'bex_details' => json_encode($curencyInfo),
            'donation_id' => $information['causeId'],
        ]);
    }

    public function generateInvoice($donation, $userId)
    {

        $fileName = $donation->transaction_id . ".pdf";

        $directory = public_path(Constant::WEBSITE_DONATION_INVOICE . '/');
        if (!file_exists($directory)) {
            mkdir($directory, 0775, true);
        }
        $fileLocated = $directory . $fileName;

        $language = $this->getUserCurrentLanguage($userId);
        $cause = Donation::query()
            ->where('id', $donation->donation_id)
            ->firstOrFail();
        $causeInfo = DonationContent::query()
            ->where('user_id', $userId)
            ->where('donation_id', $cause->id)
            ->where('language_id', $language->id)
            ->select('title')
            ->firstOrFail();

        PDF::loadView('pdf.donation', compact('donation', 'causeInfo'))->save($fileLocated);

        return $fileName;
    }

    public function sendMail($donationInfo, $userId)
    {

        $mailTemplate = UserEmailTemplate::query()
            ->where('email_type', 'donation')
            ->where('user_id', $userId)
            ->first();
        $mailSubject = $mailTemplate->email_subject;
        $mailBody = $mailTemplate->email_body;

        // second get the website title & mail's smtp info from db
        $be = DB::table('basic_extendeds')
            ->select('is_smtp', 'smtp_host', 'smtp_username', 'smtp_password', 'from_mail', 'from_name')
            ->first();

        $userBs = BasicSetting::query()->where('user_id', $userId)
            ->select('website_title', 'email', 'from_name')
            ->first();



        $language = $this->getUserCurrentLanguage($userId);
        $cause = Donation::query()
            ->where('id', $donationInfo->donation_id)
            ->firstOrFail();
        $causeInfo = DonationContent::query()
            ->where('user_id', $userId)
            ->where('donation_id', $cause->id)
            ->where('language_id', $language->id)
            ->select('title')
            ->firstOrFail();

        $websiteTitle = $userBs->website_title;

        $mailBody = str_replace('{donor_name}', $donationInfo->name, $mailBody);
        $mailBody = str_replace('{cause_name}', $causeInfo->title, $mailBody);
        $mailBody = str_replace('{website_title}', $websiteTitle, $mailBody);


        // initialize a new mail
        $mail = new PHPMailer(true);
        $mail->CharSet = 'UTF-8';
        $mail->Encoding = 'base64';

        // if smtp status == 1, then set some value for PHPMailer
        if ($be->is_smtp == 1) {
            $mail->isSMTP();
            $mail->Host = $be->smtp_host;
            $mail->SMTPAuth = true;
            $mail->Username = $be->smtp_username;
            $mail->Password = $be->smtp_password;
            // if ($be->encryption == 'TLS') {
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            // }
            $mail->Port = 587;
        }
        // finally, add other informations and send the mail
        try {
            // Recipients
            $mail->setFrom($be->from_mail, $userBs->from_name);
            $mail->addReplyTo($userBs->email, $userBs->from_name);
            $mail->addAddress($donationInfo->email);
            $path = public_path(Constant::WEBSITE_DONATION_INVOICE . '/' . $donationInfo->invoice);
            // Attachments (Invoice)

            $mail->addAttachment($path);
            // Content
            $mail->isHTML(true);
            $mail->Subject = $mailSubject;
            $mail->Body = $mailBody;
            $mail->send();
            @unlink(public_path(Constant::WEBSITE_DONATION_INVOICE) . '/' . $donationInfo->invoice);
            return;
        } catch (\Exception $e) {
            return session()->flash('error', 'Mail could not be sent! Mailer Error: ' . $e);
        }
    }
    public function complete(Request $request)
    {
        if ($request->via == 'offline') {
            $request = $request->via;
            return view('user-front.offline-success', compact('request'));
        } else {

            $request = 'online';
            return view('user-front.success', compact('request'));
        }
    }
    public function cancel(Request $request, $domain, $id)
    {
        $user = getUser();
        $language = $this->getUserCurrentLanguage($user->id);
        $donation = Donation::query()->where('user_id', $user->id)->findOrFail($id);

        $donationInfo = DonationContent::query()
            ->where('donation_id', $donation->id)
            ->where('user_id', $user->id)
            ->where('language_id', $language->id)
            ->firstOrFail();

        session()->flash('error', 'Sorry, an error has occurred!');

        return redirect()->route('front.user.causesDetails', [getParam(), 'slug' => $donationInfo->slug]);
    }
}
